/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.input;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import com.badlogic.gdx.ai.msg.Telegram;
import com.badlogic.gdx.ai.msg.Telegraph;
import com.badlogic.gdx.utils.Disposable;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.List;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.assets.model.GameMaterialType;
import technology.rocketjump.undermount.doors.DoorwayOrientation;
import technology.rocketjump.undermount.doors.DoorwaySize;
import technology.rocketjump.undermount.gamecontext.GameContext;
import technology.rocketjump.undermount.gamecontext.GameContextAware;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.messaging.types.DebugMessage;
import technology.rocketjump.undermount.messaging.types.DoorwayPlacementMessage;
import technology.rocketjump.undermount.misc.VectorUtils;

@Singleton
public class DebugMessageHandler
implements GameContextAware,
Telegraph,
Disposable {
    private final MessageDispatcher messageDispatcher;
    private GameContext gameContext;
    private int materialCounter;
    private List<GameMaterial> materials = new ArrayList<GameMaterial>();

    @Inject
    public DebugMessageHandler(MessageDispatcher messageDispatcher, GameMaterialDictionary materialDictionary) {
        this.messageDispatcher = messageDispatcher;
        this.materials.add(materialDictionary.getByName("Fir wood"));
        this.materials.add(materialDictionary.getByName("Dolostone"));
        GameMaterial testMetal = new GameMaterial("Test metal", -1L, GameMaterialType.METAL, "#aaaaaa", null, null, null, false);
        this.materials.add(testMetal);
        messageDispatcher.addListener(this, -7);
    }

    @Override
    public void dispose() {
        this.messageDispatcher.removeListener((Telegraph)this, -7);
    }

    @Override
    public boolean handleMessage(Telegram msg) {
        switch (msg.message) {
            case -7: {
                DebugMessage debugMessage = (DebugMessage)msg.extraInfo;
                MapTile tile = this.gameContext.getAreaMap().getTile(debugMessage.getWorldPosition());
                if (tile.hasWall()) {
                    this.messageDispatcher.dispatchMessage(606, tile.getTilePosition());
                } else if (!tile.hasWall() && !tile.hasDoorway()) {
                    MapTile north = this.gameContext.getAreaMap().getTile(debugMessage.getWorldPosition().cpy().add(0.0f, 1.0f));
                    MapTile south = this.gameContext.getAreaMap().getTile(debugMessage.getWorldPosition().cpy().add(0.0f, -1.0f));
                    MapTile west = this.gameContext.getAreaMap().getTile(debugMessage.getWorldPosition().cpy().add(-1.0f, 0.0f));
                    MapTile east = this.gameContext.getAreaMap().getTile(debugMessage.getWorldPosition().cpy().add(1.0f, 0.0f));
                    if (north.hasWall() && south.hasWall() && !east.hasWall() && !east.hasDoorway() && !west.hasWall() && !west.hasDoorway()) {
                        this.messageDispatcher.dispatchMessage(801, new DoorwayPlacementMessage(DoorwaySize.SINGLE, DoorwayOrientation.NORTH_SOUTH, this.pickMaterial(), VectorUtils.toGridPoint(debugMessage.getWorldPosition())));
                        return true;
                    }
                    if (west.hasWall() && east.hasWall() && !north.hasWall() && !north.hasDoorway() && !south.hasWall() && !south.hasDoorway()) {
                        this.messageDispatcher.dispatchMessage(801, new DoorwayPlacementMessage(DoorwaySize.SINGLE, DoorwayOrientation.EAST_WEST, this.pickMaterial(), VectorUtils.toGridPoint(debugMessage.getWorldPosition())));
                        return true;
                    }
                }
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected message type " + msg.message + " received by " + this.toString() + ", " + msg.toString());
    }

    private GameMaterial pickMaterial() {
        return this.materials.get(0);
    }

    @Override
    public void onContextChange(GameContext gameContext) {
        this.gameContext = gameContext;
    }
}

